<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$quote_id = $_GET['id'] ?? 0;
$agent_id = $_SESSION['agent_id'];

$sql_quote = "SELECT q.id, q.quote_number, q.created_at, q.status, c.name AS customer_name, c.email AS customer_email, c.phone AS customer_phone
              FROM quotes q 
              JOIN customers c ON q.customer_id = c.id
              WHERE q.id = ? AND q.agent_id = ?";
$stmt_quote = $conn->prepare($sql_quote);
$stmt_quote->bind_param("ii", $quote_id, $agent_id);
$stmt_quote->execute();
$quote = $stmt_quote->get_result()->fetch_assoc();

if (!$quote) {
    echo "Teklif bulunamadı veya bu teklifi görüntüleme yetkiniz yok.";
    exit;
}

$sql_items = "SELECT qi.quantity, qi.unit_price, p.sku, p.name AS product_name, p.image_url
              FROM quote_items qi
              JOIN products p ON qi.product_id = p.id
              WHERE qi.quote_id = ?";
$stmt_items = $conn->prepare($sql_items);
$stmt_items->bind_param("i", $quote_id);
$stmt_items->execute();
$items = $stmt_items->get_result();

include 'header.php';
?>

<h1>Teklif Detayı - #<?php echo htmlspecialchars($quote['quote_number']); ?></h1>
<div class="details-box">
    <p><strong>Müşteri:</strong> <?php echo htmlspecialchars($quote['customer_name']); ?></p>
    <p><strong>Durum:</strong> <?php echo htmlspecialchars($quote['status']); ?></p>
    <p><strong>Oluşturulma Tarihi:</strong> <?php echo htmlspecialchars($quote['created_at']); ?></p>
</div>

<h2>Teklif Edilen Ürünler</h2>
<?php if ($items->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Görsel</th>
                <th>SKU</th>
                <th>Ürün Adı</th>
                <th>Adet</th>
                <th>Birim Fiyat</th>
                <th>Toplam</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $grand_total = 0;
            while($item = $items->fetch_assoc()): 
                $total = $item['quantity'] * $item['unit_price'];
                $grand_total += $total;
            ?>
            <tr>
                <td>
                    <?php if (!empty($item['image_url'])): ?>
                        <img src="<?php echo htmlspecialchars($item['image_url']); ?>" alt="<?php echo htmlspecialchars($item['product_name']); ?>">
                    <?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars($item['sku']); ?></td>
                <td><?php echo htmlspecialchars($item['product_name']); ?></td>
                <td><?php echo htmlspecialchars($item['quantity']); ?></td>
                <td><?php echo number_format($item['unit_price'], 2) . " TL"; ?></td>
                <td><?php echo number_format($total, 2) . " TL"; ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="5" style="text-align: right;"><strong>Genel Toplam:</strong></td>
                <td><strong><?php echo number_format($grand_total, 2) . " TL"; ?></strong></td>
            </tr>
        </tfoot>
    </table>
<?php else: ?>
    <p>Bu teklifte ürün bulunmamaktadır.</p>
<?php endif; ?>

<div style="text-align: center; margin-top: 20px;">
    <a href="list_quotes.php" class="btn btn-secondary">Teklif Listesine Dön</a>
</div>

<?php
$stmt_quote->close();
$stmt_items->close();
$conn->close();
include 'footer.php';
?>