<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Kategorileri veritabanından çekme
$sql_categories = "SELECT id, name, image_url FROM categories ORDER BY name ASC";
$categories = $conn->query($sql_categories);

include 'header.php';
?>

<h1>Kategori Yönetimi</h1>
<p>Yeni kategori ekleyebilir veya mevcut kategorileri silebilirsiniz.</p>

<div class="card" style="margin-bottom: 30px; padding: 20px;">
    <h2>Yeni Kategori Ekle</h2>
    <form id="add-category-form">
        <div class="form-group">
            <label for="category_name">Kategori Adı:</label>
            <input type="text" id="category_name" name="category_name" required>
        </div>
        <div class="form-group">
            <label for="image_url">Görsel URL:</label>
            <input type="text" id="image_url" name="image_url">
        </div>
        <button type="submit" class="btn btn-primary">Kategori Ekle</button>
    </form>
</div>

<h2>Mevcut Kategoriler</h2>
<?php if ($categories->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Görsel</th>
                <th>Kategori Adı</th>
                <th>İşlem</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $categories->fetch_assoc()): ?>
            <tr>
                <td>
                    <?php if (!empty($row['image_url'])): ?>
                        <img src="<?php echo htmlspecialchars($row['image_url']); ?>" alt="<?php echo htmlspecialchars($row['name']); ?>" class="product-image-thumbnail">
                    <?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars($row['name']); ?></td>
                <td>
                    <button class="btn btn-danger delete-category-btn" data-id="<?php echo $row['id']; ?>">Sil</button>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Henüz eklenmiş kategori bulunmamaktadır.</p>
<?php endif; ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $('#add-category-form').on('submit', function(e) {
        e.preventDefault();
        const categoryName = $('#category_name').val();
        const imageUrl = $('#image_url').val();
        
        if (categoryName === '') {
            alert("Kategori adı boş olamaz.");
            return;
        }

        $.ajax({
            url: 'add_category.php',
            method: 'POST',
            data: { name: categoryName, image_url: imageUrl },
            success: function(response) {
                alert(response.message);
                if (response.status === 'success') {
                    location.reload();
                }
            }
        });
    });

    $('.delete-category-btn').click(function() {
        const categoryId = $(this).data('id');
        const confirmation = confirm("Bu kategoriyi silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.");
        
        if (confirmation) {
            $.ajax({
                url: 'delete_category.php',
                method: 'POST',
                data: { id: categoryId },
                success: function(response) {
                    alert(response.message);
                    if (response.status === 'success') {
                        location.reload();
                    }
                }
            });
        }
    });
});
</script>

<?php
$conn->close();
include 'footer.php';
?>