<?php
session_start();
require 'db_connection.php';

header('Content-Type: application/json');

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => 'Lütfen giriş yapın.']);
    exit;
}

$product_id = $_POST['product_id'] ?? null;

if (empty($product_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Ürün ID\'si eksik.']);
    exit;
}

try {
    $sql = "DELETE FROM products WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $product_id);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Ürün başarıyla silindi.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Silinecek ürün bulunamadı.']);
    }
    
    $stmt->close();
} catch (mysqli_sql_exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Silme işlemi sırasında bir hata oluştu: ' . $e->getMessage()]);
}

$conn->close();
?>