<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}
$agent_name = $_SESSION['agent_name'];

// TOPLAM ÜRÜN SAYISINI ÇEKME
$sql_total_products = "SELECT COUNT(id) AS total_products FROM products";
$result_total_products = $conn->query($sql_total_products);
$total_products = $result_total_products->fetch_assoc()['total_products'];

// TOPLAM MÜŞTERİ SAYISINI ÇEKME
$sql_total_customers = "SELECT COUNT(id) AS total_customers FROM customers WHERE agent_id = ?";
$stmt_total_customers = $conn->prepare($sql_total_customers);
$stmt_total_customers->bind_param("i", $_SESSION['agent_id']);
$stmt_total_customers->execute();
$result_total_customers = $stmt_total_customers->get_result();
$total_customers = $result_total_customers->fetch_assoc()['total_customers'];
$stmt_total_customers->close();

// EN ÇOK SATAN İLK 3 ÜRÜNÜ ÇEKME
$sql_top_sellers = "SELECT p.name AS product_name, p.image_url, SUM(qi.quantity) AS total_sold 
                    FROM quote_items qi 
                    JOIN products p ON qi.product_id = p.id 
                    GROUP BY p.id 
                    ORDER BY total_sold DESC 
                    LIMIT 3";
$result_top_sellers = $conn->query($sql_top_sellers);

// BUGÜNKÜ TOPLAM CİROYU HESAPLAMA (Tamamlanan Tekliflerden)
$sql_daily_revenue = "SELECT SUM(qi.quantity * qi.unit_price) AS daily_revenue 
                      FROM quotes q 
                      JOIN quote_items qi ON q.id = qi.quote_id 
                      WHERE q.status = 'completed' AND DATE(q.created_at) = CURDATE()";
$result_daily_revenue = $conn->query($sql_daily_revenue);
$daily_revenue = $result_daily_revenue->fetch_assoc()['daily_revenue'] ?? 0;

// BUGÜN TAMAMLANAN TEKLİF SAYISINI ÇEKME
$sql_daily_sales = "SELECT COUNT(id) AS daily_sales FROM quotes WHERE status = 'completed' AND DATE(created_at) = CURDATE()";
$result_daily_sales = $conn->query($sql_daily_sales);
$daily_sales = $result_daily_sales->fetch_assoc()['daily_sales'] ?? 0;

include 'header.php';
?>

<h1>Yönetim Paneli</h1>
<p>Merhaba <?php echo htmlspecialchars($agent_name); ?>, işte bugünkü özetiniz.</p>

<div class="dashboard-metrics-grid">
    <div class="metric-card">
        <p class="metric-label">Toplam Ürün</p>
        <h2 class="metric-value"><?php echo $total_products; ?></h2>
    </div>
    <div class="metric-card">
        <p class="metric-label">Bugünkü Ciro</p>
        <h2 class="metric-value"><?php echo number_format($daily_revenue, 2) . " TL"; ?></h2>
    </div>
    <div class="metric-card">
        <p class="metric-label">Toplam Müşteri</p>
        <h2 class="metric-value"><?php echo $total_customers; ?></h2>
    </div>
    <div class="metric-card">
        <p class="metric-label">Bugün Tamamlanan Teklif</p>
        <h2 class="metric-value"><?php echo $daily_sales; ?></h2>
    </div>
</div>

<h2>En Çok Satanlar</h2>
<div class="metric-card">
    <div class="top-sellers-grid">
        <?php if ($result_top_sellers->num_rows > 0): ?>
            <?php while($seller = $result_top_sellers->fetch_assoc()): ?>
                <div class="top-seller-item">
                    <img src="<?php echo htmlspecialchars($seller['image_url']); ?>" alt="<?php echo htmlspecialchars($seller['product_name']); ?>">
                    <p><?php echo htmlspecialchars($seller['product_name']); ?></p>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <p>Henüz yeterli satış verisi yok.</p>
        <?php endif; ?>
    </div>
</div>

<?php
include 'footer.php';
?>