<?php
require 'db_connection.php';
session_start();

$category_id = $_GET['category_id'] ?? 0;

$sql_category = "SELECT name FROM categories WHERE id = '" . mysqli_real_escape_string($conn, $category_id) . "'";
$category_result = $conn->query($sql_category);
$category_name = $category_result->fetch_assoc()['name'] ?? 'Tüm Ürünler';

$sql_products = "SELECT id, sku, name, description, price, image_url FROM products WHERE category_id = '" . mysqli_real_escape_string($conn, $category_id) . "' ORDER BY name ASC";
$products = $conn->query($sql_products);

include 'header_public.php';
?>

<a href="customer_home.php" class="btn btn-secondary" style="margin-bottom: 20px;">← Kategorilere Geri Dön</a>
<div class="cart-summary" style="text-align: center; margin-bottom: 20px; font-size: 1.1em;">
    <span id="cart-item-count">0</span> Ürün Sepetinizde. <a href="quote_request_form.php" class="btn btn-primary">Sipariş Fişi Oluştur</a>
</div>
<h1><?php echo htmlspecialchars($category_name); ?></h1>
<div class="product-list">
    <?php if ($products->num_rows > 0): ?>
        <?php while($row = $products->fetch_assoc()): ?>
            <div class="product-item">
                <img src="<?php echo htmlspecialchars($row['image_url']); ?>" alt="<?php echo htmlspecialchars($row['name']); ?>">
                <div class="item-content">
                    <h3 class="item-title"><?php echo htmlspecialchars($row['name']); ?></h3>
                    <p class="item-price"><?php echo number_format($row['price'], 2) . " TL"; ?></p>
                    <p><?php echo htmlspecialchars($row['description']); ?></p>
                </div>
                <button class="add-to-cart-btn btn-success" data-id="<?php echo $row['id']; ?>" data-name="<?php echo htmlspecialchars($row['name']); ?>" data-price="<?php echo $row['price']; ?>">Sepete Ekle</button>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <p>Bu kategoride henüz ürün bulunmamaktadır.</p>
    <?php endif; ?>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    let cart = JSON.parse(localStorage.getItem('touzmoda_cart')) || {};

    function updateCartCount() {
        let count = 0;
        for (let id in cart) {
            count += cart[id].quantity;
        }
        $('#cart-item-count').text(count);
    }

    updateCartCount();

    $('.add-to-cart-btn').click(function() {
        const productId = $(this).data('id');
        const productName = $(this).data('name');
        const productPrice = parseFloat($(this).data('price'));
        
        if (cart[productId]) {
            cart[productId].quantity += 1;
        } else {
            cart[productId] = {
                id: productId,
                name: productName,
                price: productPrice,
                quantity: 1
            };
        }
        
        localStorage.setItem('touzmoda_cart', JSON.stringify(cart));
        updateCartCount();
        alert(productName + " sepete eklendi!");
    });
});
</script>

<?php
$conn->close();
include 'footer.php';
?>