<?php
require 'db_connection.php';
session_start();

$name = $_POST['name'] ?? null;
$email = $_POST['email'] ?? null;
$password = $_POST['password'] ?? null;

if (empty($name) || empty($email) || empty($password)) {
    die("Lütfen tüm alanları doldurun.");
}

$hashed_password = password_hash($password, PASSWORD_DEFAULT);

$conn->begin_transaction();
try {
    // 1. customers tablosuna kaydet
    // Yeni müşteriye atanan bir satış temsilcisi olmadığı için agent_id NULL olarak kaydedilir
    $sql_customer = "INSERT INTO customers (agent_id, name, email) VALUES (NULL, ?, ?)";
    $stmt_customer = $conn->prepare($sql_customer);
    $stmt_customer->bind_param("ss", $name, $email);
    $stmt_customer->execute();
    $customer_id = $conn->insert_id;
    $stmt_customer->close();
    
    // 2. Ardından customer_accounts tablosuna hesap bilgilerini kaydet
    $sql_account = "INSERT INTO customer_accounts (customer_id, email, password) VALUES (?, ?, ?)";
    $stmt_account = $conn->prepare($sql_account);
    $stmt_account->bind_param("iss", $customer_id, $email, $hashed_password);
    $stmt_account->execute();
    $stmt_account->close();
    
    $conn->commit();
    
    // Kayıt başarılıysa otomatik giriş yap
    $_SESSION['customer_id'] = $customer_id;
    $_SESSION['customer_logged_in'] = true;
    header("Location: customer_dashboard.php");
    exit();
    
} catch (mysqli_sql_exception $e) {
    $conn->rollback();
    echo "Hata: Kayıt işlemi başarısız. Lütfen tekrar deneyin.";
    // Daha detaylı hata mesajı için: echo "Hata: " . $e->getMessage();
}

$conn->close();
?>