<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$sql_requests = "SELECT * FROM quote_requests ORDER BY created_at DESC";
$requests = $conn->query($sql_requests);

include 'header.php';
?>

<h1>Gelen Teklif Talepleri</h1>
<?php if ($requests->num_rows > 0): ?>
    <?php while($request = $requests->fetch_assoc()): ?>
        <div class="card" style="margin-bottom: 20px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                <h2 style="font-size: 1.2em; margin: 0;">Taleb: <?php echo htmlspecialchars($request['name']); ?></h2>
                <span class="status-badge status-<?php echo htmlspecialchars($request['status']); ?>">
                    <?php echo htmlspecialchars(str_replace('_', ' ', $request['status'])); ?>
                </span>
            </div>
            <p><strong>E-posta:</strong> <?php echo htmlspecialchars($request['email']); ?></p>
            <p><strong>Telefon:</strong> <?php echo htmlspecialchars($request['phone']); ?></p>
            <p><strong>Talep Notu:</strong> <?php echo nl2br(htmlspecialchars($request['message'])); ?></p>
            <hr>
            <h3>Talep Edilen Ürünler:</h3>
            <ul style="padding-left: 20px;">
                <?php
                $sql_items = "SELECT qri.quantity, qri.unit_price, p.name AS product_name
                              FROM quote_request_items qri
                              JOIN products p ON qri.product_id = p.id
                              WHERE qri.request_id = " . $request['id'];
                $items = $conn->query($sql_items);
                if ($items->num_rows > 0) {
                    while($item = $items->fetch_assoc()) {
                        echo "<li>" . htmlspecialchars($item['product_name']) . " - " . htmlspecialchars($item['quantity']) . " Adet</li>";
                    }
                } else {
                    echo "<li>Ürün bilgisi bulunmamaktadır.</li>";
                }
                ?>
            </ul>
        </div>
    <?php endwhile; ?>
<?php else: ?>
    <p style="text-align: center;">Henüz gelen bir teklif talebi bulunmamaktadır.</p>
<?php endif; ?>

<?php
$conn->close();
include 'footer.php';
?>