<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];

$sql_customers = "SELECT * FROM customers WHERE agent_id = ? ORDER BY name ASC";
$stmt_customers = $conn->prepare($sql_customers);
$stmt_customers->bind_param("i", $agent_id);
$stmt_customers->execute();
$customers = $stmt_customers->get_result();

include 'header.php';
?>

<h1>Müşteri Listesi</h1>
<?php if ($customers->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Müşteri Adı / Firma</th>
                <th>E-posta</th>
                <th>Telefon</th>
                <th>Adres</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $customers->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['name']); ?></td>
                <td><?php echo htmlspecialchars($row['email']); ?></td>
                <td><?php echo htmlspecialchars($row['phone']); ?></td>
                <td><?php echo htmlspecialchars($row['address']); ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Henüz eklenmiş müşteriniz bulunmamaktadır.</p>
<?php endif; ?>

<?php
$stmt_customers->close();
$conn->close();
include 'footer.php';
?>