<?php
session_start();
require 'db_connection.php';
require_once 'dompdf/autoload.inc.php';

use Dompdf\Dompdf;
use Dompdf\Options;

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    echo "Yetkiniz yok.";
    exit;
}

$quote_number = $_GET['quote_number'] ?? null;

if (empty($quote_number)) {
    echo "Geçersiz teklif numarası.";
    exit;
}

// Teklif ve müşteri bilgilerini çekme
$sql_quote = "SELECT q.id, q.quote_number, q.created_at, q.status, c.name AS customer_name, c.email AS customer_email, c.phone AS customer_phone
              FROM quotes q 
              JOIN customers c ON q.customer_id = c.id
              WHERE q.quote_number = ? AND q.agent_id = ?";
$stmt_quote = $conn->prepare($sql_quote);
$stmt_quote->bind_param("si", $quote_number, $_SESSION['agent_id']);
$stmt_quote->execute();
$quote = $stmt_quote->get_result()->fetch_assoc();
$stmt_quote->close();

if (!$quote) {
    echo "Teklif bulunamadı veya yetkiniz yok.";
    exit;
}

// Teklife ait ürünleri çekme
$sql_items = "SELECT qi.quantity, qi.unit_price, p.sku, p.name AS product_name, p.image_url
              FROM quote_items qi
              JOIN products p ON qi.product_id = p.id
              WHERE qi.quote_id = ?";
$stmt_items = $conn->prepare($sql_items);
$stmt_items->bind_param("i", $quote['id']);
$stmt_items->execute();
$items = $stmt_items->get_result();
$stmt_items->close();

$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 30px; }
        .footer { position: fixed; bottom: 0; width: 100%; text-align: center; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Touzmoda Fiyat Teklifi</h1>
        <p>Teklif Numarası: ' . htmlspecialchars($quote['quote_number']) . '</p>
    </div>
    
    <h3>Müşteri Bilgileri</h3>
    <table>
        <tr>
            <th>Adı Soyadı</th>
            <td>' . htmlspecialchars($quote['customer_name']) . '</td>
        </tr>
        <tr>
            <th>E-posta</th>
            <td>' . htmlspecialchars($quote['customer_email']) . '</td>
        </tr>
        <tr>
            <th>Telefon</th>
            <td>' . htmlspecialchars($quote['customer_phone']) . '</td>
        </tr>
    </table>
    
    <h3>Teklif Detayları</h3>
    <table>
        <thead>
            <tr>
                <th>Ürün Adı</th>
                <th>SKU</th>
                <th>Adet</th>
                <th>Birim Fiyat</th>
                <th>Toplam</th>
            </tr>
        </thead>
        <tbody>';
            $grand_total = 0;
            while($item = $items->fetch_assoc()) {
                $total = $item['quantity'] * $item['unit_price'];
                $grand_total += $total;
                $html .= '<tr>
                            <td>' . htmlspecialchars($item['product_name']) . '</td>
                            <td>' . htmlspecialchars($item['sku']) . '</td>
                            <td>' . htmlspecialchars($item['quantity']) . '</td>
                            <td>' . number_format($item['unit_price'], 2) . ' TL</td>
                            <td>' . number_format($total, 2) . ' TL</td>
                          </tr>';
            }
$html .= '</tbody>
        <tfoot>
            <tr>
                <td colspan="4" style="text-align: right;"><strong>Genel Toplam:</strong></td>
                <td><strong>' . number_format($grand_total, 2) . ' TL</strong></td>
            </tr>
        </tfoot>
    </table>
    
    <div class="footer">
        <p>Touzmoda | ' . date('Y') . '</p>
    </div>
</body>
</html>
';

$options = new Options();
$options->set('defaultFont', 'DejaVu Sans');
$dompdf = new Dompdf($options);

$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$dompdf->stream('teklif-' . $quote['quote_number'] . '.pdf', array('Attachment' => 0));

$conn->close();
?>