<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$product_id = $_GET['id'] ?? 0;

if (empty($product_id)) {
    echo "Geçersiz ürün ID'si.";
    exit;
}

// Ürün bilgilerini çekme
$sql_product = "SELECT * FROM products WHERE id = ?";
$stmt_product = $conn->prepare($sql_product);
$stmt_product->bind_param("i", $product_id);
$stmt_product->execute();
$product = $stmt_product->get_result()->fetch_assoc();
$stmt_product->close();

if (!$product) {
    echo "Ürün bulunamadı.";
    exit;
}

// Kategorileri çekme
$sql_categories = "SELECT id, name FROM categories ORDER BY name ASC";
$categories = $conn->query($sql_categories);

include 'header.php';
?>

<h1>Ürün Düzenle</h1>
<form action="update_product.php" method="POST">
    <input type="hidden" name="product_id" value="<?php echo htmlspecialchars($product['id']); ?>">
    
    <div class="form-group">
        <label for="category_id">Kategori Seçin:</label>
        <select id="category_id" name="category_id">
            <option value="">-- Kategori Seçiniz --</option>
            <?php while($row = $categories->fetch_assoc()): ?>
                <option value="<?php echo $row['id']; ?>" <?php echo ($row['id'] == $product['category_id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($row['name']); ?>
                </option>
            <?php endwhile; ?>
        </select>
    </div>
    
    <div class="form-group">
        <label for="sku">Stok Kodu (SKU):</label>
        <input type="text" id="sku" name="sku" value="<?php echo htmlspecialchars($product['sku']); ?>" required>
    </div>
    
    <div class="form-group">
        <label for="name">Ürün Adı:</label>
        <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($product['name']); ?>" required>
    </div>
    
    <div class="form-group">
        <label for="description">Açıklama:</label>
        <textarea id="description" name="description" rows="4"><?php echo htmlspecialchars($product['description']); ?></textarea>
    </div>
    
    <div class="form-group">
        <label for="price">Fiyat:</label>
        <input type="number" id="price" name="price" step="0.01" value="<?php echo htmlspecialchars($product['price']); ?>" required>
    </div>
    
    <div class="form-group">
        <label for="stock_quantity">Stok Adedi:</label>
        <input type="number" id="stock_quantity" name="stock_quantity" value="<?php echo htmlspecialchars($product['stock_quantity']); ?>" required>
    </div>
    
    <div class="form-group">
        <label for="image_url">Görsel URL:</label>
        <input type="text" id="image_url" name="image_url" value="<?php echo htmlspecialchars($product['image_url']); ?>">
    </div>
    
    <div class="form-group">
        <input type="submit" class="btn btn-primary" value="Ürünü Güncelle">
    </div>
</form>

<?php
$conn->close();
include 'footer.php';
?>