<?php
session_start();
require 'db_connection.php';
header('Content-Type: application/json');

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    echo json_encode(['status' => 'error', 'message' => 'Lütfen giriş yapın.']);
    exit;
}

$category_id = $_POST['id'] ?? null;

if (empty($category_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Kategori ID\'si eksik.']);
    exit;
}

$sql = "DELETE FROM categories WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $category_id);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Kategori başarıyla silindi.']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Hata: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>