<?php
session_start();
require 'db_connection.php';

// Müşterinin giriş yapıp yapmadığını kontrol et
if (!isset($_SESSION['customer_logged_in']) || $_SESSION['customer_logged_in'] !== true) {
    header("Location: customer_login.php");
    exit;
}

$customer_id = $_SESSION['customer_id'];

// Müşteriye ait tüm teklifleri ve talepleri çekme
$sql_quotes = "SELECT q.id, q.quote_number, q.created_at, q.status
               FROM quotes q
               WHERE q.customer_id = ?
               ORDER BY q.created_at DESC";
$stmt_quotes = $conn->prepare($sql_quotes);
$stmt_quotes->bind_param("i", $customer_id);
$stmt_quotes->execute();
$quotes = $stmt_quotes->get_result();

include 'header_public.php';
?>

<h1>Müşteri Paneli</h1>
<p>Gönderdiğiniz tüm teklif taleplerini buradan takip edebilirsiniz.</p>
<hr>

<h2>Teklifleriniz</h2>
<?php if ($quotes->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Teklif No</th>
                <th>Durum</th>
                <th>Tarih</th>
                <th>İşlem</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $quotes->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['quote_number']); ?></td>
                <td>
                    <span class="status-badge status-<?php echo htmlspecialchars($row['status']); ?>">
                        <?php echo htmlspecialchars(str_replace('_', ' ', $row['status'])); ?>
                    </span>
                </td>
                <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                <td>
                    <a href="public_quote_view.php?quote_number=<?php echo $row['quote_number']; ?>" class="btn btn-primary" style="padding: 5px 10px;">Görüntüle</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Henüz gönderdiğiniz bir teklif talebi bulunmamaktadır.</p>
<?php endif; ?>

<?php
$stmt_quotes->close();
$conn->close();
include 'footer.php';
?>