<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$sql_categories = "SELECT id, name FROM categories ORDER BY name ASC";
$categories = $conn->query($sql_categories);

include 'header.php';
?>

<h1>Yeni Ürün Ekle</h1>
<form action="add_product_process.php" method="POST">
    <div class="form-group">
        <label for="category_id">Kategori Seçin:</label>
        <select id="category_id" name="category_id">
            <option value="">-- Kategori Seçiniz --</option>
            <?php while($row = $categories->fetch_assoc()): ?>
                <option value="<?php echo $row['id']; ?>"><?php echo htmlspecialchars($row['name']); ?></option>
            <?php endwhile; ?>
        </select>
    </div>
    <div class="form-group">
        <label for="sku">Stok Kodu (SKU):</label>
        <input type="text" id="sku" name="sku" required>
    </div>
    <div class="form-group">
        <label for="name">Ürün Adı:</label>
        <input type="text" id="name" name="name" required>
    </div>
    <div class="form-group">
        <label for="description">Açıklama:</label>
        <textarea id="description" name="description" rows="4"></textarea>
    </div>
    <div class="form-group">
        <label for="price">Fiyat:</label>
        <input type="number" id="price" name="price" step="0.01" required>
    </div>
    <div class="form-group">
        <label for="image_url">Görsel URL:</label>
        <input type="text" id="image_url" name="image_url">
    </div>
    <div class="form-group">
        <input type="submit" class="btn btn-success" value="Ürünü Kaydet">
    </div>
</form>

<?php
$conn->close();
include 'footer.php';
?>