<?php
session_start();
require 'db_connection.php';

$quote_number = $_GET['quote_number'] ?? null;
if (empty($quote_number)) {
    die("Geçersiz teklif numarası.");
}

$sql_quote = "SELECT q.*, c.name AS customer_name, c.email AS customer_email, c.phone AS customer_phone
              FROM quotes q 
              JOIN customers c ON q.customer_id = c.id
              WHERE q.quote_number = ?";
$stmt = $conn->prepare($sql_quote);
$stmt->bind_param("s", $quote_number);
$stmt->execute();
$quote = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$quote) {
    die("Teklif bulunamadı.");
}

$sql_items = "SELECT qi.*, p.sku, p.name, p.image_url FROM quote_items qi JOIN products p ON qi.product_id = p.id WHERE qi.quote_id = ?";
$stmt_items = $conn->prepare($sql_items);
$stmt_items->bind_param("i", $quote['id']);
$stmt_items->execute();
$items = $stmt_items->get_result();
$stmt_items->close();

include 'header_public.php';
?>

<h1>Teklif Detayı - #<?php echo htmlspecialchars($quote['quote_number']); ?></h1>
<div style="margin-bottom: 20px;">
    <a href="generate_quote_pdf.php?quote_number=<?php echo htmlspecialchars($quote['quote_number']); ?>" class="btn btn-primary" target="_blank">PDF Olarak İndir</a>
</div>
<div class="card" style="margin-bottom: 20px;">
    <h2>Müşteri Bilgileri</h2>
    <p><strong>Müşteri:</strong> <?php echo htmlspecialchars($quote['customer_name']); ?></p>
    <p><strong>E-posta:</strong> <?php echo htmlspecialchars($quote['customer_email']); ?></p>
    <p><strong>Telefon:</strong> <?php echo htmlspecialchars($quote['customer_phone']); ?></p>
</div>

<div class="card">
    <h2>Ürünler</h2>
    <?php if ($items->num_rows > 0): ?>
        <table>
            <thead>
                <tr>
                    <th>Görsel</th>
                    <th>SKU</th>
                    <th>Ürün Adı</th>
                    <th>Adet</th>
                    <th>Birim Fiyat</th>
                    <th>Toplam Fiyat</th>
                </tr>
            </thead>
            <tbody>
                <?php $grand_total = 0; ?>
                <?php while($item = $items->fetch_assoc()): ?>
                    <?php $total = $item['quantity'] * $item['unit_price']; ?>
                    <?php $grand_total += $total; ?>
                    <tr>
                        <td>
                            <?php if (!empty($item['image_url'])): ?>
                                <img src="<?php echo htmlspecialchars($item['image_url']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>" class="product-image-thumbnail">
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($item['sku']); ?></td>
                        <td><?php echo htmlspecialchars($item['name']); ?></td>
                        <td><?php echo htmlspecialchars($item['quantity']); ?></td>
                        <td><?php echo number_format($item['unit_price'], 2) . " TL"; ?></td>
                        <td><?php echo number_format($total, 2) . " TL"; ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="5" style="text-align: right;"><strong>Genel Toplam:</strong></td>
                    <td><strong><?php echo number_format($grand_total, 2) . " TL"; ?></strong></td>
                </tr>
            </tfoot>
        </table>
    <?php else: ?>
        <p>Bu teklif için ürün bulunmamaktadır.</p>
    <?php endif; ?>
</div>

<?php
$conn->close();
include 'footer.php';
?>