<?php
session_start();
require 'db_connection.php';

$email = $_POST['email'];
$password = $_POST['password'];

$sql = "SELECT id, name, password FROM agents WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $agent = $result->fetch_assoc();
    if (password_verify($password, $agent['password'])) {
        $_SESSION['agent_id'] = $agent['id'];
        $_SESSION['agent_name'] = $agent['name'];
        $_SESSION['logged_in'] = true;
        header("Location: dashboard.php");
        exit();
    } else {
        echo "Hatalı şifre.";
    }
} else {
    echo "Kullanıcı bulunamadı.";
}

$stmt->close();
$conn->close();
?>