<?php
require 'db_connection.php';

$sql_categories = "SELECT id, name, image_url FROM categories ORDER BY name ASC";
$categories = $conn->query($sql_categories);

include 'header_public.php';
?>

<h1>Toptan Ürün Kategorileri</h1>
<p style="text-align: center;">Toptan satışa uygun ürünlerimizi kategorilere göre inceleyebilirsiniz.</p>

<div class="category-list">
    <?php if ($categories->num_rows > 0): ?>
        <?php while($row = $categories->fetch_assoc()): ?>
            <a href="customer_products.php?category_id=<?php echo $row['id']; ?>" class="category-item">
                <img src="<?php echo htmlspecialchars($row['image_url']); ?>" alt="<?php echo htmlspecialchars($row['name']); ?>" class="category-image">
                <div class="item-content">
                    <h3 class="item-title"><?php echo htmlspecialchars($row['name']); ?></h3>
                </div>
            </a>
        <?php endwhile; ?>
    <?php else: ?>
        <p>Henüz eklenmiş kategori bulunmamaktadır.</p>
    <?php endif; ?>
</div>

<?php
$conn->close();
include 'footer.php';
?>