<?php
session_start();
require 'db_connection.php';

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$agent_id = $_SESSION['agent_id'];
$name = $_POST['name'] ?? null;
$email = $_POST['email'] ?? null;
$phone = $_POST['phone'] ?? null;
$address = $_POST['address'] ?? null;

$success = false;
$error_message = "";

$sql = "INSERT INTO customers (agent_id, name, email, phone, address) VALUES (?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("issss", $agent_id, $name, $email, $phone, $address);
    if ($stmt->execute()) {
        $success = true;
    } else {
        $error_message = "Müşteri eklenirken bir hata oluştu: " . $stmt->error;
    }
    $stmt->close();
} else {
    $error_message = "Sorgu hazırlanamadı: " . $conn->error;
}
$conn->close();

include 'header.php';

if ($success) {
    echo '<div class="message-box">';
    echo '<h1>Müşteri Başarıyla Eklendi</h1>';
    echo '<p>Yeni müşteri başarıyla kaydedildi.</p>';
    echo '<a href="dashboard.php" class="btn btn-primary">Yönetim Paneline Dön</a>';
    echo '</div>';
} else {
    echo '<div class="message-box error">';
    echo '<h1>Hata</h1>';
    echo '<p>' . $error_message . '</p>';
    echo '<a href="dashboard.php" class="btn btn-secondary">Geri Dön</a>';
    echo '</div>';
}

include 'footer.php';
?>